/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWStepItem;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWStepsListCellRenderer;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VWRuleSetUsageDialog
extends VWModalDialog
implements ActionListener,
IVWListUpdateListener,
IVWPropertyChangeSource {
    private VWAuthPropertyData m_authPropertyData = null;
    private Vector<VWMapNode> m_stepVector = null;
    private JComboBox m_ruleSetComboBox = null;
    private JComboBox m_submapComboBox = null;
    private JComboBox m_typeComboBox = null;
    private VWAddRemovePanel m_addRemovePanel = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;

    public VWRuleSetUsageDialog(VWAuthPropertyData authPropertyData) {
        super(authPropertyData.getMainContainer());
        try {
            this.m_authPropertyData = authPropertyData;
            Dimension dim = VWStringUtils.stringToDimension("665,445");
            if (dim != null) {
                this.setSize(dim);
            } else {
                this.setSize(new Dimension(600, 400));
            }
            this.setTitle(VWResource.s_ruleSetUsage);
            this.createControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWRuleSetDefinition ruleSetDef) {
        this.initializeSubmapComboBox();
        this.initializeRuleSetComboBox();
        this.m_ruleSetComboBox.setSelectedItem(ruleSetDef);
    }

    public boolean hasMaps() {
        if (this.m_submapComboBox != null) {
            return this.m_submapComboBox.getModel().getSize() > 0;
        }
        return false;
    }

    public void releaseReferences() {
        if (this.m_ruleSetComboBox != null) {
            this.m_ruleSetComboBox.removeActionListener(this);
            this.m_ruleSetComboBox.removeAllItems();
            this.m_ruleSetComboBox = null;
        }
        if (this.m_submapComboBox != null) {
            this.m_submapComboBox.removeActionListener(this);
            this.m_submapComboBox.removeAllItems();
            this.m_submapComboBox = null;
        }
        if (this.m_typeComboBox != null) {
            this.m_typeComboBox.removeActionListener(this);
            this.m_typeComboBox.removeAllItems();
            this.m_typeComboBox = null;
        }
        if (this.m_addRemovePanel != null) {
            this.m_addRemovePanel.removeListUpdateListener(this);
            this.m_addRemovePanel.removeReferences();
            this.m_addRemovePanel = null;
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source.equals(this.m_ruleSetComboBox)) {
                this.reinitializeLists();
            } else if (source.equals(this.m_submapComboBox)) {
                this.reinitializeLists();
            } else if (source.equals(this.m_typeComboBox)) {
                this.reinitializeLists();
            } else if (source.equals(this.m_closeButton)) {
                this.setVisible(false);
            } else if (source.equals(this.m_helpButton)) {
                VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh154.htm");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void listUpdated(Object source, int nEventType, Object[] items) {
        switch (nEventType) {
            case 1: {
                this.addRuleSetToSteps(items);
                break;
            }
            case 2: {
                this.removeRuleSetFromSteps(items);
            }
        }
    }

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_stepVector;
    }

    private void createControls() {
        try {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(9, 9, 3, 3);
            this.getContentPane().add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_ruleSets)), gbCons);
            this.m_ruleSetComboBox = new JComboBox();
            this.m_ruleSetComboBox.addActionListener(this);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.getContentPane().add((Component)this.m_ruleSetComboBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(3, 9, 3, 3);
            this.getContentPane().add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_submap)), gbCons);
            this.m_submapComboBox = new JComboBox();
            this.m_submapComboBox.addActionListener(this);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.getContentPane().add((Component)this.m_submapComboBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.getContentPane().add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_type)), gbCons);
            Vector<String> names = new Vector<String>();
            names.addElement(VWResource.s_beforeExecution);
            names.addElement(VWResource.s_onSave);
            names.addElement(VWResource.s_afterCompletion);
            this.m_typeComboBox = new JComboBox(names);
            this.m_typeComboBox.addActionListener(this);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.getContentPane().add((Component)this.m_typeComboBox, gbCons);
            this.m_addRemovePanel = new VWAddRemovePanel(10);
            this.m_addRemovePanel.setAvailableItemName(VWResource.s_availableSteps);
            this.m_addRemovePanel.setSelectedItemName(VWResource.s_selectedSteps);
            this.m_addRemovePanel.enableSorting(768);
            this.m_addRemovePanel.addListUpdateListener(this);
            this.m_addRemovePanel.setListCellRenderer(new VWStepsListCellRenderer(null));
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.getContentPane().add((Component)this.m_addRemovePanel, gbCons);
            JPanel bottomPanel = new JPanel(new FlowLayout());
            this.m_closeButton = new JButton(VWResource.s_closeStr);
            this.m_closeButton.addActionListener(this);
            bottomPanel.add((Component)this.m_closeButton, gbCons);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            bottomPanel.add((Component)this.m_helpButton, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 9, 6, 3);
            this.getContentPane().add((Component)bottomPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRuleSetComboBox() {
        DefaultComboBoxModel<Object> comboBoxModel = new DefaultComboBoxModel<Object>();
        try {
            try {
                Object[] ruleSetDefs;
                if (this.m_authPropertyData != null && (ruleSetDefs = this.m_authPropertyData.getRuleSets()) != null && ruleSetDefs.length > 0) {
                    VWQuickSort sortRuleSets = new VWQuickSort(ruleSetDefs, 0);
                    sortRuleSets.sort(0, ruleSetDefs.length);
                    for (int i = 0; i < ruleSetDefs.length; ++i) {
                        comboBoxModel.addElement(ruleSetDefs[i]);
                    }
                }
                Object var6_6 = null;
                this.m_ruleSetComboBox.setModel(comboBoxModel);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var6_7 = null;
                this.m_ruleSetComboBox.setModel(comboBoxModel);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_ruleSetComboBox.setModel(comboBoxModel);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSubmapComboBox() {
        DefaultComboBoxModel<Object> comboBoxModel = new DefaultComboBoxModel<Object>();
        try {
            try {
                if (this.m_authPropertyData != null) {
                    Vector<String> mapNamesVec = new Vector<String>();
                    VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getCurrentMapDefinitions();
                    if (mapDefs != null) {
                        if (this.m_authPropertyData.getMapCache().get("Workflow", false) != null) {
                            comboBoxModel.addElement("Workflow");
                        }
                        for (int i = 0; i < mapDefs.length; ++i) {
                            if (VWStringUtils.compare(mapDefs[i].getName(), "Workflow") == 0) continue;
                            mapNamesVec.addElement(mapDefs[i].getName());
                        }
                    }
                    if (mapNamesVec != null && mapNamesVec.size() > 0) {
                        Object[] mapNames = new String[mapNamesVec.size()];
                        mapNamesVec.copyInto(mapNames);
                        VWQuickSort sortMap = new VWQuickSort(mapNames, 0);
                        sortMap.sort(0, mapNames.length);
                        for (int i = 0; i < mapNames.length; ++i) {
                            if (VWStringUtils.compareIgnoreCase((String)mapNames[i], "") == 0) continue;
                            comboBoxModel.addElement(mapNames[i]);
                        }
                    }
                }
                Object var8_9 = null;
                this.m_submapComboBox.setModel(comboBoxModel);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var8_10 = null;
                this.m_submapComboBox.setModel(comboBoxModel);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.m_submapComboBox.setModel(comboBoxModel);
            throw throwable;
        }
    }

    private void reinitializeLists() {
        try {
            Vector<VWStepItem> availableStepsVector = new Vector<VWStepItem>();
            VWMapNode[] availableMapNodes = this.getAvailableMapNodes();
            if (availableMapNodes != null && availableMapNodes.length > 0) {
                for (int i = 0; i < availableMapNodes.length; ++i) {
                    VWStepItem stepItem = new VWStepItem(availableMapNodes[i].getName(), availableMapNodes[i]);
                    stepItem.setSelected(false);
                    availableStepsVector.addElement(stepItem);
                }
            }
            Object[] availableSteps = new VWStepItem[availableStepsVector.size()];
            availableStepsVector.copyInto(availableSteps);
            Vector<VWStepItem> selectedStepsVector = new Vector<VWStepItem>();
            VWMapNode[] selectedMapNodes = this.getSelectedMapNodes(availableMapNodes);
            if (selectedMapNodes != null && selectedMapNodes.length > 0) {
                for (int i = 0; i < selectedMapNodes.length; ++i) {
                    VWStepItem stepItem = new VWStepItem(selectedMapNodes[i].getName(), selectedMapNodes[i]);
                    stepItem.setSelected(true);
                    selectedStepsVector.addElement(stepItem);
                }
            }
            Object[] selectedSteps = new VWStepItem[selectedStepsVector.size()];
            selectedStepsVector.copyInto(selectedSteps);
            this.m_addRemovePanel.initializeLists(availableSteps, selectedSteps);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWMapNode[] getAvailableMapNodes() {
        Object[] stepDefs = null;
        try {
            VWWorkflowDefinition wfDef;
            if (this.m_authPropertyData != null && this.m_submapComboBox.getItemCount() > 0 && (wfDef = this.m_authPropertyData.getWorkflowDefinition()) != null) {
                VWMapNode[] mapNodes;
                VWMapDefinition mapDef;
                String mapName = (String)this.m_submapComboBox.getSelectedItem();
                if (mapName == null && this.m_submapComboBox.getItemCount() > 0) {
                    mapName = (String)this.m_submapComboBox.getItemAt(0);
                }
                if ((mapDef = wfDef.getMap(mapName)) != null && (mapNodes = mapDef.getSteps()) != null && mapNodes.length > 0) {
                    Vector<VWMapNode> stepDefVector = new Vector<VWMapNode>();
                    for (int i = 0; i < mapNodes.length; ++i) {
                        if (!this.isValidStep(mapNodes[i])) continue;
                        stepDefVector.addElement(mapNodes[i]);
                    }
                    stepDefs = new VWMapNode[stepDefVector.size()];
                    stepDefVector.copyInto(stepDefs);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return stepDefs;
    }

    private boolean isValidStep(VWMapNode mapNode) {
        int nStepType = VWStepUtils.getStepType(mapNode);
        if (nStepType == -1) {
            return false;
        }
        switch (this.m_typeComboBox.getSelectedIndex()) {
            case 0: {
                return nStepType != 0;
            }
            case 1: {
                return VWStepUtils.isGeneralStep(nStepType) || VWStepUtils.isStartGeneralStep(nStepType);
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    private VWMapNode[] getSelectedMapNodes(VWMapNode[] availableMapNodes) {
        Object[] stepDefs = null;
        try {
            if (availableMapNodes != null && availableMapNodes.length > 0) {
                Vector<VWMapNode> stepDefVector = new Vector<VWMapNode>();
                VWRuleSetDefinition ruleSetDef = (VWRuleSetDefinition)this.m_ruleSetComboBox.getSelectedItem();
                int nType = this.m_typeComboBox.getSelectedIndex();
                block2: for (int i = 0; i < availableMapNodes.length; ++i) {
                    String[] ruleSetNames = availableMapNodes[i].getRuleSetNames(nType);
                    VWRuleSetDefinition[] ruleSetDefs = this.m_authPropertyData.getRuleSetsByName(ruleSetNames);
                    if (ruleSetDefs == null || ruleSetDefs.length <= 0) continue;
                    for (int j = 0; j < ruleSetDefs.length; ++j) {
                        if (!ruleSetDefs[j].equals(ruleSetDef)) continue;
                        stepDefVector.addElement(availableMapNodes[i]);
                        continue block2;
                    }
                }
                stepDefs = new VWMapNode[stepDefVector.size()];
                stepDefVector.copyInto(stepDefs);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return stepDefs;
    }

    private void addRuleSetToSteps(Object[] items) {
        try {
            this.m_stepVector = new Vector();
            VWRuleSetDefinition ruleSetDef = (VWRuleSetDefinition)this.m_ruleSetComboBox.getSelectedItem();
            int nType = this.m_typeComboBox.getSelectedIndex();
            for (int i = 0; i < items.length; ++i) {
                VWStepItem item = (VWStepItem)items[i];
                VWMapNode mapNode = item.getDef();
                if (mapNode == null) continue;
                Vector<Object> tempRuleSets = new Vector<Object>();
                Object[] currentRuleSetNames = mapNode.getRuleSetNames(nType);
                if (currentRuleSetNames != null && currentRuleSetNames.length > 0) {
                    for (int j = 0; j < currentRuleSetNames.length; ++j) {
                        tempRuleSets.addElement(currentRuleSetNames[j]);
                    }
                }
                tempRuleSets.addElement(ruleSetDef.getName());
                currentRuleSetNames = new String[tempRuleSets.size()];
                tempRuleSets.copyInto(currentRuleSetNames);
                mapNode.setRuleSets(nType, (String[])currentRuleSetNames);
                item.setSelected(true);
                this.m_stepVector.addElement(mapNode);
            }
            this.m_authPropertyData.setDirty();
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 553);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void removeRuleSetFromSteps(Object[] items) {
        try {
            this.m_stepVector = new Vector();
            VWRuleSetDefinition ruleSetDef = (VWRuleSetDefinition)this.m_ruleSetComboBox.getSelectedItem();
            int nType = this.m_typeComboBox.getSelectedIndex();
            for (int i = 0; i < items.length; ++i) {
                VWStepItem item = (VWStepItem)items[i];
                VWMapNode mapNode = item.getDef();
                if (mapNode == null) continue;
                Vector<Object> tempRuleSets = new Vector<Object>();
                Object[] currentRuleSetNames = mapNode.getRuleSetNames(nType);
                if (currentRuleSetNames != null && currentRuleSetNames.length > 0) {
                    for (int j = 0; j < currentRuleSetNames.length; ++j) {
                        if (VWStringUtils.compare((String)currentRuleSetNames[j], ruleSetDef.getName()) == 0) continue;
                        tempRuleSets.addElement(currentRuleSetNames[j]);
                    }
                }
                currentRuleSetNames = new String[tempRuleSets.size()];
                tempRuleSets.copyInto(currentRuleSetNames);
                mapNode.setRuleSets(nType, (String[])currentRuleSetNames);
                item.setSelected(false);
                this.m_stepVector.addElement(mapNode);
            }
            this.m_authPropertyData.setDirty();
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 553);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

